{\rtf1\ansi\ansicpg1252\deff0\deftab720{\fonttbl{\f0\fswiss MS Sans Serif;}{\f1\froman\fcharset2 Symbol;}{\f2\fmodern\fprq1 Courier New;}{\f3\froman Times New Roman;}{\f4\fswiss Arial;}}
{\colortbl\red0\green0\blue0;}
\deflang1033\horzdoc{\*\fchars }{\*\lchars }\pard\ri-360\plain\f2\fs22 --
\par -- This file contains both Oracle and SQL Server sql statements that
\par -- create various objects in an attempt to illustrate how some of these
\par -- objects can be migrated from one database type to the other. 
\par --
\par 
\par CREATE TABLE SCOTT.DEPT
\par   (DEPTNO    NUMBER(2)    CONSTRAINT PK_DEPT PRIMARY KEY,
\par    DNAME     VARCHAR2(14),
\par    LOC       VARCHAR2(13) 
\par );
\par 
\par or
\par 
\par CREATE TABLE DEPT
\par   (DEPTNO    NUMBER(2)    CONSTRAINT PK_DEPT PRIMARY KEY,
\par    DNAME      VARCHAR2(14),
\par    LOC        VARCHAR2(13)
\par );
\par \pard\plain\f4\fs20 
\par \pard\ri-360\plain\f2\fs22 --
\par -- Adding a user defined data type and then using it in a CREATE TABLE
\par -- statement
\par --
\par 
\par sp_addtype address_type, 'varchar(30)', 'NOT NULL'
\par go
\par \pard\plain\f4\fs20 
\par \pard\ri-360\plain\f2\fs22 CREATE TABLE Customers (
\par   cust_id     numeric(10)   NOT NULL,
\par   cust_name   varchar(30)    NULL,
\par   address     address_type  NULL,
\par   phone_num   varchar(15)    NULL
\par )
\par go
\par 
\par --
\par -- creating an OBJECT type within Oracle
\par --
\par 
\par CREATE TYPE purchase_order AS OBJECT (
\par   purchase_order_id   NUMBER(10,0),
\par   company_name        VARCHAR2(20),
\par   amount              NUMBER(8,2)
\par );
\par 
\par 
\par --
\par -- creating a collection type in Oracle. The first is a simple
\par -- array of decimal numbers (max of 20) while the second is a 
\par -- collection of purchase_order object types created above.
\par --
\par 
\par CREATE TYPE prices AS VARRAY(20) OF NUMBER(8,2)
\par ; 
\par 
\par CREATE TYPE purchase_order_table AS TABLE of purchase_order
\par ;
\par 
\par -- 
\par -- create the authors table in SQL Server using the IDENTITY property
\par -- to automatically populate the author_id column. This property can be
\par -- simulated in Oracle with a sequence as shown below.
\par --
\par 
\par CREATE TABLE authors
\par (
\par    author_id    int     IDENTITY(1,1),
\par    first_name   varchar (20),
\par    mid_initial  varchar(1),
\par    last_name    varchar(30)
\par )
\par go
\par 
\par 
\par create sequence next_id
\par   start with 1
\par   increment by 1
\par   minvalue 1
\par   maxvalue 1000000
\par   cache 20
\par   cycle
\par   order
\par ;
\par 
\par create or replace trigger INSERT_SEQUENCE_NUMBER
\par before INSERT on AUTHORS
\par for each row
\par declare
\par    next_seq_id  INTEGER;
\par begin
\par     select next_id.nextval into next_seq_id from dual;
\par     :new.author_id := next_seq_id;
\par end;
\par /
\par 
\par 
\par -- 
\par -- simulate an Oracle sequence in SQL Server
\par --
\par 
\par create table next_object_id (
\par    id        NUMERIC(10)  IDENTITY(1,1) NOT NULL,
\par    seq_date  DATETIME                   NOT NULL
\par )
\par go
\par 
\par 
\par CREATE PROCEDURE NextSequenceID @nextid int OUTPUT
\par AS
\par  INSERT INTO next_object_id ( seq_date ) VALUES ( GETDATE() )
\par  SELECT @nextid = @@IDENTITY
\par  DELETE FROM next_object_id
\par go
\par 
\par 
\par 
\par 
\par --
\par -- Creating primary key constraints within the CREATE TABLE statement
\par -- or as an ALTER TABLE statement. Which you use is a personal preference
\par --
\par 
\par \plain\f2\fs20 CREATE TABLE DEPT
\par  (DEPTNO    NUMBER(2)  NOT NULL  CONSTRAINT PK_DEPT PRIMARY KEY,
\par   DNAME     VARCHAR2(14),
\par   LOC       VARCHAR2(13) 
\par )
\par ;
\par 
\par ALTER TABLE DEPT ADD CONSTRAINT PK_DEPT PRIMARY KEY(DEPTNO);
\par \plain\f2\fs22 
\par 
\par --
\par -- Creating foreign key constraints in an Oracle database
\par --
\par 
\par CREATE TABLE DEPT
\par  (DEPTNO   NUMBER(2) CONSTRAINT PK_DEPT PRIMARY KEY,
\par   DNAME    VARCHAR2(14) ,
\par   LOC      VARCHAR2(13) ) 
\par ;
\par 
\par CREATE TABLE EMP
\par  (EMPNO    NUMBER(4) CONSTRAINT PK_EMP PRIMARY KEY,
\par   ENAME    VARCHAR2(10),
\par   JOB      VARCHAR2(9),
\par   MGR      NUMBER(4),
\par   HIREDATE DATE,
\par   SAL      NUMBER(7,2),
\par   COMM     NUMBER(7,2),
\par   DEPTNO   NUMBER(2) )
\par ;
\par 
\par ALTER TABLE EMP 
\par ADD CONSTRAINT FK_DEPTNO FOREIGN KEY(DEPTNO)
\par REFERENCES DEPT(DEPTNO) 
\par ON DELETE SET NULL
\par ;
\par 
\par 
\par --
\par -- Function based indexes in Oracle
\par --
\par 
\par CREATE INDEX IX_FUNCTIONAL ON TABLE_1 (c1 + (c1*c2), c1, c2);
\par 
\par SELECT c1, c2 from TABLE_1 WHERE c1+(c1*c2) > 2500;
\par 
\par --
\par -- Function based indexes in SQL Server
\par --
\par 
\par CREATE TABLE TABLE_1 (
\par C1   smallint,
\par C2   smallint,
\par C3 as C1+(c1*c2)
\par )
\par go
\par 
\par create index ix_functional on table_1(c3)
\par go
\par 
\par }
 